/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.client.gui.screens;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.client.ChartaClient;
import dev.lucaargolo.charta.client.gui.screens.OptionsScreen;
import dev.lucaargolo.charta.game.CardDeck;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.game.CardGames;
import dev.lucaargolo.charta.network.CardTableSelectGamePayload;
import dev.lucaargolo.charta.utils.ChartaGuiGraphics;
import dev.lucaargolo.charta.utils.TickableWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import net.minecraft.class_7919;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableScreen
extends class_437 {
    private final class_2338 pos;
    private final CardDeck deck;
    private final int[] players;
    private GameWidget<?> widget;

    public TableScreen(class_2338 pos, CardDeck deck, int[] players) {
        super((class_2561)class_2561.method_43471((String)"message.charta.choose_game"));
        this.pos = pos;
        this.deck = deck;
        this.players = players;
    }

    protected void method_25426() {
        super.method_25426();
        this.widget = (GameWidget)this.method_37063((class_364)new GameWidget(this.field_22787, this.field_22789, this.field_22790 - 60, 30));
        CardGames.getGames().forEach((gameId, gameFactory) -> this.widget.addEntry(new Game((class_2960)gameId, gameFactory)));
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 10, -1);
        if (this.field_22787 != null) {
            guiGraphics.method_27534(this.field_22793, (class_2561)class_2561.method_43469((String)"message.charta.hold_to_options", (Object[])new Object[]{this.field_22787.field_1690.field_1832.field_1655.method_27445()}), this.field_22789 / 2, this.field_22790 - 20, -1);
        }
    }

    public void method_25393() {
        if (this.field_22787 != null) {
            int mouseX = (int)(this.field_22787.field_1729.method_1603() * (double)this.field_22787.method_22683().method_4486() / (double)this.field_22787.method_22683().method_4480());
            int mouseY = (int)(this.field_22787.field_1729.method_1604() * (double)this.field_22787.method_22683().method_4502() / (double)this.field_22787.method_22683().method_4507());
            for (class_364 widget : this.method_25396()) {
                if (!(widget instanceof TickableWidget)) continue;
                TickableWidget tickable = (TickableWidget)widget;
                tickable.tick(mouseX, mouseY);
            }
        }
    }

    public boolean method_25421() {
        return false;
    }

    private boolean isShiftDown() {
        assert (this.field_22787 != null);
        return class_3675.method_15987((long)this.field_22787.method_22683().method_4490(), (int)this.field_22787.field_1690.field_1832.field_1655.method_1444());
    }

    public class GameWidget<G extends CardGame<G>>
    extends class_4265<GameRow<G>>
    implements TickableWidget {
        private final int amount;

        public GameWidget(class_310 minecraft, int width, int height, int y) {
            super(minecraft, width, height, y, 75);
            int margin = width - 40;
            this.amount = margin / 75;
        }

        public void addEntry(@NotNull Game<G> entry) {
            if (this.method_25396().isEmpty() || ((GameRow)((Object)this.method_25396().getLast())).games.size() >= this.amount) {
                this.method_25321((class_350.class_351)new GameRow());
            }
            ((GameRow)((Object)this.method_25396().getLast())).games.add(entry);
            class_5250 play = class_2561.method_43470((String)"\ue037").method_27696(Charta.SYMBOLS);
            class_4185 playWidget = class_4185.method_46430((class_2561)play, button -> entry.method_25306()).method_46434(0, 0, 20, 20).method_46431();
            playWidget.field_22763 = entry.field_22763;
            playWidget.method_47400(class_7919.method_47407((class_2561)(entry.tooltip != null ? entry.tooltip : class_2561.method_43471((String)"message.charta.play_game"))));
            ((GameRow)((Object)this.method_25396().getLast())).plays.add(playWidget);
            class_5250 config = class_2561.method_43470((String)"\ue8b8").method_27696(Charta.SYMBOLS);
            class_4185 configWidget = class_4185.method_46430((class_2561)config, button -> this.field_22740.method_1507(new OptionsScreen(TableScreen.this, TableScreen.this.pos, entry.game, entry.gameId, entry.gameFactory, false))).method_46434(0, 0, 20, 20).method_46431();
            configWidget.field_22763 = entry.field_22763 && !((CardGame)entry.game).getOptions().isEmpty();
            configWidget.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"message.charta.configure_game")));
            ((GameRow)((Object)this.method_25396().getLast())).configs.add(configWidget);
        }

        public int method_25322() {
            return this.amount * 75 - 5;
        }

        @Override
        public void tick(int mouseX, int mouseY) {
            for (GameRow row : this.method_25396()) {
                for (Game game : row.games) {
                    game.tick(mouseX, mouseY);
                }
            }
        }
    }

    public class Game<G extends CardGame<G>>
    extends class_4185
    implements TickableWidget {
        private final class_2960 gameId;
        private final CardGames.Factory<G> gameFactory;
        private final class_2960 texture;
        private final G game;
        @Nullable
        private final class_2561 tooltip;
        private float lastInset;
        private float inset;
        private float lastFov;
        private float fov;

        public Game(class_2960 gameId, CardGames.Factory<G> gameFactory) {
            super(0, 0, 70, 70, (class_2561)class_2561.method_43471((String)gameId.method_42094()), button -> {
                ClientPlayNetworking.send((class_8710)new CardTableSelectGamePayload(dev$lucaargolo$charta$client$gui$screens$TableScreen$this.pos, gameId, ChartaClient.LOCAL_OPTIONS.getOrDefault(gameId, new byte[0])));
                TableScreen.this.method_25419();
            }, class_4185.field_40754);
            this.lastInset = 0.0f;
            this.inset = 0.0f;
            this.lastFov = 30.0f;
            this.fov = 37.0f;
            this.gameId = gameId;
            this.gameFactory = gameFactory;
            this.texture = gameId.method_45138("textures/gui/game/").method_48331(".png");
            this.game = gameFactory.create(List.of(), CardDeck.EMPTY);
            boolean invalidDeck = !CardGame.canPlayGame(this.game, TableScreen.this.deck);
            boolean notEnoughPlayers = TableScreen.this.players.length < ((CardGame)this.game).getMinPlayers();
            boolean tooManyPlayers = TableScreen.this.players.length > ((CardGame)this.game).getMaxPlayers();
            boolean bl = this.field_22763 = !invalidDeck && !notEnoughPlayers && !tooManyPlayers;
            this.tooltip = invalidDeck ? class_2561.method_43471((String)"message.charta.cant_play_deck").method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"message.charta.try_finding_another")) : (notEnoughPlayers ? class_2561.method_43469((String)"message.charta.not_enough_players", (Object[])new Object[]{((CardGame)this.game).getMinPlayers()}) : (tooManyPlayers ? class_2561.method_43469((String)"message.charta.too_many_players", (Object[])new Object[]{((CardGame)this.game).getMaxPlayers()}) : null));
        }

        protected void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (this.method_49606() && TableScreen.this.isShiftDown()) {
                this.field_22762 = false;
            }
            if (this.field_22763) {
                float inset = class_3532.method_16439((float)partialTick, (float)this.lastInset, (float)this.inset);
                float fov = class_3532.method_16439((float)partialTick, (float)this.lastFov, (float)this.fov);
                ChartaClient.CARD_INSET.accept(Float.valueOf(inset));
                ChartaClient.CARD_FOV.accept(Float.valueOf(fov));
                ChartaClient.CARD_X_ROT.accept(Float.valueOf(0.0f));
                ChartaClient.CARD_Y_ROT.accept(Float.valueOf(0.0f));
                float xOffset = ((float)this.method_25368() * 1.333333f - (float)this.method_25368()) / 2.0f;
                float yOffset = ((float)this.method_25364() * 1.333333f - (float)this.method_25364()) / 2.0f;
                ChartaGuiGraphics.blitPerspective(guiGraphics, this.texture, (float)this.method_46426() - xOffset, (float)this.method_46427() - yOffset, (float)this.method_25368() + xOffset * 2.0f, (float)this.method_25364() + yOffset * 2.0f);
                this.lastInset = inset;
                this.lastFov = fov;
            } else {
                ChartaGuiGraphics.blitGrayscale(guiGraphics, this.texture, this.method_46426(), this.method_46427(), 70.0f, 70.0f);
            }
            if (this.method_49606()) {
                if (this.field_22763) {
                    guiGraphics.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + 70, this.method_46427() + 70, 0x33FFFFFF);
                } else {
                    guiGraphics.method_25294(this.method_46426() + 2, this.method_46427() + 2, this.method_46426() + 68, this.method_46427() + 68, 0x33FFFFFF);
                }
            } else if (TableScreen.this.isShiftDown()) {
                guiGraphics.method_25294(this.method_46426() + 2, this.method_46427() + 2, this.method_46426() + 68, this.method_46427() + 68, 0x66000000);
            }
        }

        @Override
        public void tick(int mouseX, int mouseY) {
            this.inset = this.method_49606() ? -30.0f : 0.0f;
            this.fov = 37.0f;
        }
    }

    public class GameRow<G extends CardGame<G>>
    extends class_4265.class_4266<GameRow<G>> {
        protected List<Game<G>> games = new ArrayList<Game<G>>();
        protected List<class_4185> plays = new ArrayList<class_4185>();
        protected List<class_4185> configs = new ArrayList<class_4185>();

        public void method_25343(@NotNull class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            int i = 0;
            for (Game<G> game : this.games) {
                game.method_46421(left + i * 75);
                game.method_46419(top);
                game.method_25394(guiGraphics, mouseX, mouseY, partialTick);
                if (game.method_49606() && game.tooltip != null) {
                    TableScreen.this.method_47415(game.tooltip);
                }
                ++i;
            }
            if (TableScreen.this.isShiftDown()) {
                i = 0;
                for (class_4185 button : this.plays) {
                    button.method_46421(left + i * 75 + 25 - 12);
                    button.method_46419(top + 25);
                    button.method_25394(guiGraphics, mouseX, mouseY, partialTick);
                    ++i;
                }
                i = 0;
                for (class_4185 button : this.configs) {
                    button.method_46421(left + i * 75 + 25 + 12);
                    button.method_46419(top + 25);
                    button.method_25394(guiGraphics, mouseX, mouseY, partialTick);
                    ++i;
                }
            }
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return TableScreen.this.isShiftDown() ? Stream.concat(this.plays.stream(), this.configs.stream()).toList() : this.games;
        }

        @NotNull
        public List<? extends class_6379> method_37025() {
            return TableScreen.this.isShiftDown() ? Stream.concat(this.plays.stream(), this.configs.stream()).toList() : this.games;
        }
    }
}

